<?php
require_once __DIR__ . '/config.php';

try {
    // Create users table
    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        email TEXT NOT NULL UNIQUE,
        password TEXT NOT NULL,
        role TEXT NOT NULL DEFAULT 'advertiser',
        created_at TEXT NOT NULL
    )");

    // Create devices table
    $db->exec("CREATE TABLE IF NOT EXISTS devices (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        owner_id INTEGER NOT NULL,
        title TEXT NOT NULL,
        type TEXT,
        width REAL,
        height REAL,
        description TEXT,
        address TEXT,
        lat REAL,
        lng REAL,
        price_month REAL,
        price_week REAL,
        price_day REAL,
        main_image TEXT,
        created_at TEXT NOT NULL,
        FOREIGN KEY(owner_id) REFERENCES users(id)
    )");

    // Create bookings table
    $db->exec("CREATE TABLE IF NOT EXISTS bookings (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        start_date TEXT NOT NULL,
        end_date TEXT NOT NULL,
        total_price REAL NOT NULL,
        status TEXT NOT NULL DEFAULT 'pending',
        created_at TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id),
        FOREIGN KEY(user_id) REFERENCES users(id)
    )");

    // Create images table
    $db->exec("CREATE TABLE IF NOT EXISTS images (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        path TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id)
    )");

    // Create availability table
    $db->exec("CREATE TABLE IF NOT EXISTS availability (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        start_date TEXT NOT NULL,
        end_date TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id)
    );");

    // Create default admin if not exists
    $stmt = $db->prepare("SELECT COUNT(*) as c FROM users WHERE email = :email");
    $adminEmail = 'admin@prisastatic.com';
    $stmt->execute([':email' => $adminEmail]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ((int)$row['c'] === 0) {
        $password = password_hash('admin123', PASSWORD_DEFAULT);
        $now = date('c');
        $ins = $db->prepare("INSERT INTO users (name, email, password, role, created_at) VALUES (:name, :email, :password, :role, :created_at)");
        $ins->execute([
            ':name' => 'Admin Prisa Static',
            ':email' => $adminEmail,
            ':password' => $password,
            ':role' => 'admin',
            ':created_at' => $now
        ]);
        echo 'Database initialized and admin user created (admin@prisastatic.com / admin123).';
    } else {
        echo 'Database already initialized.';
    }

} catch (Exception $e) {
    echo 'Error initializing database: ' . $e->getMessage();
}
?>
