<?php
require_once __DIR__ . '/config.php';
$user = current_user();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prisa Static</title>
    <link rel="stylesheet" href="styles.css">
    <!-- Mapbox GL JS (for mapas de ubicación) -->
    <link href="https://api.mapbox.com/mapbox-gl-js/v2.15.0/mapbox-gl.css" rel="stylesheet" />
    <script src="https://api.mapbox.com/mapbox-gl-js/v2.15.0/mapbox-gl.js"></script>
</head>
<body>
<header>
    <div class="logo"><a href="index.php">Prisa Static</a></div>
    <nav>
        <a href="index.php">Marketplace</a>
        <?php if ($user && $user['role'] === 'owner'): ?>
            <a href="owner_dashboard.php">Mis soportes</a>
            <a href="device_new.php">Publicar soporte</a>
        <?php endif; ?>
        <?php if ($user && $user['role'] === 'admin'): ?>
            <a href="admin_dashboard.php">Admin</a>
        <?php endif; ?>
        <?php if ($user): ?>
            <a href="logout.php">Salir (<?php echo htmlspecialchars($user['name']); ?>)</a>
        <?php else: ?>
            <a href="login.php">Ingresar</a>
            <a href="register.php" class="primary">Crear cuenta</a>
        <?php endif; ?>
    </nav>
</header>
